library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

use work.procdefs.all;

entity fetch is
	port (
		clk : in std_logic;
		rst : in std_logic;
		
		--! enables the processor
		enable : in std_logic;
		
		--! ram write enable
		ram_wr : in std_logic;
		--! ram address
		ram_ad : in std_logic_vector(bit_wd-1 downto 0);
		--! ram data input
		ram_di : in std_logic_vector(bit_wd-1 downto 0);
		
		--! indicates a jump
		jmp  : in std_logic;
		--! indicates whether to write to the lower bits of the mar
		mal  : in std_logic;
		--! indicates whether to write to the upper bits of the mar
		mah  : in std_logic;
		
		--! instruction read from the memory
		inst     : out std_logic_vector(bit_wd-1 downto 0);
		--! indicates whether the instruction is valid
		inst_val : out std_logic;
		
		--! accumulator value from the execute stage
		acc  : in std_logic_vector(bit_wd-1 downto 0)			
	);
end entity fetch;

architecture RTL of fetch is
	
	component ram
		port(clk  : in  std_logic;
			 rst  : in  std_logic;
			 cs   : in  std_logic;
			 wren : in  std_logic;
			 addr : in  std_logic_vector(bit_wd - 1 downto 0);
			 di   : in  std_logic_vector(bit_wd - 1 downto 0);
			 do   : out std_logic_vector(bit_wd - 1 downto 0));
	end component ram;
	
	-- declare internal address bus, program counter, memory address register
	signal ... : std_logic_vector(...);
	
begin
	
	name : process (clk, rst) is
		
		variable var_inst_valid : std_logic;
		
	begin
		if rst = '1' then
			pc   <= (others => '0');
			mar  <= (others => '0');
			inst_val <= '0';
		elsif rising_edge(clk) then
			
			var_inst_valid := '0';
			
			if ram_wr = '0' and enable = '1' then
			
				if jmp = '0' then
					-- update program counter
					-- instruction is valid
				else
					-- update program counter with memory address register value
					-- instruction is invalid
				end if;
				
				if mal = '1' then
					-- set lower bits of mar
				end if;
				
				if mah = '1' then
					-- set upper bits of mar
				end if;
				
			end if;
			
			inst_val <= var_inst_valid;
			
		end if;
	end process name;
	
	int_addr <= ram_ad when ram_wr = '1' else pc;
		
	ram_inst : component ram
		
		port map(
			clk  => clk,
			rst  => rst,
			cs   => '1',
			wren => ram_wr,
			addr => int_addr,
			di   => ram_di,
			do   => inst
		);
	

end architecture RTL;
