library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

use work.procdefs.all;

entity proc is
	port (
		
		clk : in std_logic;
		rst : in std_logic;
		
		-- enables the processor
		enable : in std_logic;
		
		-- ram interface for writing to the program memory
		-- address
		ram_ad : in std_logic_vector(2*bit_wd-1 downto 0);
		-- write enable
		ram_wr : in std_logic;
		-- data input
		ram_di : in std_logic_vector(bit_wd-1 downto 0);
	);
end entity proc;

architecture RTL of proc is
	
	component fetch
		port(clk      : in  std_logic;
			 rst      : in  std_logic;
			 enable   : in  std_logic;
			 ram_wr   : in  std_logic;
			 ram_ad   : in  std_logic_vector(bit_wd*2-1 downto 0);
			 ram_di   : in  std_logic_vector(bit_wd-1 downto 0);
			 jmp      : in  std_logic;
			 mal      : in  std_logic;
			 mah      : in  std_logic;
			 inst     : out std_logic_vector(bit_wd - 1 downto 0);
			 inst_val : out std_logic;
			 acc      : in  std_logic_vector(bit_wd - 1 downto 0));
	end component fetch;
	
	component decode
		port(clk      : in  std_logic;
			 rst      : in  std_logic;
			 inst     : in  std_logic_vector(bit_wd - 1 downto 0);
			 inst_val : in  std_logic;
			 alu_en   : out std_logic;
			 rf_wr    : out std_logic;
			 exs      : out std_logic;
			 ins      : out std_logic;
			 sub      : out std_logic;
			 rss      : out std_logic_vector(1 downto 0);
			 din      : out std_logic_vector(bit_wd / 2 - 1 downto 0);
			 jmp      : out std_logic;
			 mal      : out std_logic;
			 mah      : out std_logic);
	end component decode;
	
	component execute
		port(clk    : in  std_logic;
			 rst    : in  std_logic;
			 alu_en : in  std_logic;
			 rf_wr  : in  std_logic;
			 exs    : in  std_logic;
			 ins    : in  std_logic;
			 sub    : in  std_logic;
			 rss    : in  std_logic_vector(1 downto 0);
			 din    : in  std_logic_vector(bit_wd / 2 - 1 downto 0);
			 acc    : out std_logic_vector(bit_wd - 1 downto 0));
	end component execute;
	
	-- declare interconnecting signals
	
begin
	
	-- instantiate pipeline stages
	
end architecture RTL;
