version 13.0

*  ***************************************************************** *
*  File-Name:      Ganghof_BJPS_Article_Empirical_Analysis.do        *
*  Date:           15/10/2015                                        *
*  Purpose:        Do-file for reproducing the empirical analysis    *
*                  of Steffen Ganghof's "Understanding Democratic    *
*		           Inclusiveness. A Partial Reinterptretation of     *
*		           Lijpharts Patterns of Democracy"	     	     *
*  ****************************************************************  *

use ganghof_2010_bjps, clear

* ****************************************************************** *
* TABLE 1                                                            *
* ****************************************************************** *
gen ltXn = LT*n_mean
label var n_mean "N"
label var LT "VETO"
label var ltXn "N X VETO"
eststo M1: reg os n_mean
eststo M2: reg os n_mean LT ltXn
eststo M3: reg os n_mean LT ltXn if country!="Mauritius" & country!="Austria"
esttab using table1.rtf, ar2(%9.2f) se(%9.2f) ///
             star("*" .1 "**" .05 "***" .01 ) ///
			 nodep brackets label replace

* ****************************************************************** *
* INTERACTION EFFECT PLOT FOR 36 countries                           *
* ****************************************************************** *

reg  os c.n_mean##LT 
margins , dydx(LT) at(n_mean=(1(1)6))

marginsplot, ytitle("Marginal Effect of Veto Points") xtitle("Effective Number of Parties") ///
             title("") scheme(s1mono) ylabel(-80(40)80, grid) yline(0) ///
			 recast(line) recastci(rline) ciopts(lp(dash)) level(95) ///
			 legend(on label(1 "95% Confidence Interval") label(2 "Marginal Effect of LT") cols(1) order( 2 1))
graph export MEP.wmf, replace

exit
