
/*
Do (Weak) Upper Houses Matter for Cabinet Formation? A Replication and Correction

Replication Do-File

*/

use EppnerGanghof_ResearchPolitics_2015_data, clear

local controls = "seats minseats minor surplus numpar dompar median gdiv1 mgodiv1 prevpm sq mginvest anmax2 pro vsp vspsing msp mspsing "

********************************Conditional Logit Models (Table 1)

*Column 1 - Replication DMT Interaction Model)
gen uppmajXasymmetric = uppmaj*asymmetric
eststo Col1: clogit realg uppmaj asymmetric uppmajXasymmetric `controls' if warmiss~=1, group(newid)

*Column 2 - Replication DMT Model 4)
eststo Col2: clogit realg uppmaj  `controls' if warmiss~=1, group(newid)

*Column 3 - DMT's Model 4 only Symmetric chambers (exclude Austria and Ireland)
eststo Col3: clogit realg uppmaj  `controls' if warmiss~=1 & country!=53 & country!=42, group(newid)

*Column 4 - DMT's Model 4 Ireland excluded
eststo Col4: clogit realg uppmaj  `controls' if warmiss~=1 & country!=53, group(newid)

*Column 5 - DMT's Model 4 Ireland recoded
eststo Col5: clogit realg uppmaj_recode  `controls' if warmiss~=1, group(newid)


esttab using table1.rtf ///
,star("*" 0.1 "**" 0.05 "***" 0.01) order(uppmaj uppmaj_recode uppmajXasymmetric `controls') ///
sca(N ll) sfmt(0) compress nogaps b(%9.2f) t(%9.2f) unstack  ///
label mtitles("Interaction" "M4" "M4 Symmetric" "M4 no IRL" "M4 IRL recode") ///
replace


********************************Mixed Logit Models (Endnote 4)
*in this model, all covariates vary
mixlogit realg , rand(surplus numpar median gdiv1 sq anmax2 seats uppmaj minor dompar mgodiv1 prevpm  mginvest pro vsp vspsing msp mspsing minseats) nrep(200) group(newid)
*only covariates vary that stand the McFadden/Train test (see Glasgow/Golder/Golder 2012) (no optimum is found in the following model)
mixlogit realg , rand(surplus numpar median gdiv1 sq anmax2 seats uppmaj minor dompar mgodiv1 prevpm  mginvest pro vsp vspsing msp mspsing minseats) nrep(200) group(newid)

********************************Alternative interaction model replication (Endnote 6)
*weak_alternative is just DMT's "stronguc1" upside down
clogit realg i.uppmaj##i.weak_alternative  `controls' if warmiss~=1, group(newid)

********************************See the coefficient for weak chambers in the interaction model (Endnote 7)
*(stronguc2 is 1 if the chamber is strong and 0 if it is weak, the coefficient for stronguc2 can be read as the influence of weak upper houses)
clogit realg i.uppmaj##i.stronguc2  `controls' if warmiss~=1, group(newid)



exit

Further information:

Most of the data is well documented in Martin/Stevenson's (2001) and Druckman/Martin/Thies' (2005) replication material,
 which are available on the respective author's websites.

We basically added the variable "uppmaj_recoded". In Ireland, it is 1 if a proto-coalition holds a majority in the 
respective senate elections given the chance to add 11 senate members to the proto-coalition's rows. 
For all cases in other countries it resembles Druckman/Martin/Thies' variable "uppmaj".
We recovered the 1981-1987 Seanad-Composition from the Senate Member Database, available on the Seanad's website 
http://www.oireachtas.ie/members-hist/default.asp




