`timescale 1ns/10ps

`include "alu_tb_op.sv"

// ========================================
// ALU TESTBENCH
// ========================================
module alu_tb ();

	// ========================================
	// DECLARATIONS
	// ========================================
	logic 		clk;
	logic 		rst;
	logic 		en; 
	logic[1:0]	rss;
	logic 		sub;
	logic[7:0]	din;
	logic[7:0]	acc;

	alu_tb_op	op;

	// ========================================
	// COVERAGE
	// ========================================
	covergroup alu_cov;
		coverpoint en;

		coverpoint rss {
			bins load 	= {0};
			bins add 			= {1};
			bins shift 			= {2};
			bins oracc 			= {3};
		}
		
		coverpoint sub;
		
		coverpoint din;
		
		coverpoint acc;

	endgroup;


	// ========================================
	// ASSERTIONS
	// ========================================
	property property_load;
		@(posedge clk) disable iff (rst)
		(en && (rss	== 0)) |-> sequence_load;
	endproperty

	sequence sequence_load;
		##1 acc == $past(din);		
	endsequence

	assert_load: assert property(property_load) 
		$display("load: PASS"); 
	else 
		$display("load: FAIL");

	property property_add;
		@(posedge clk) disable iff (rst)
		(en && (rss	== 2'b01) && (sub == 0)) |-> sequence_add;
	endproperty

	sequence sequence_add;
		##1 acc == $past(acc) + $past(din);
	endsequence

	assert_add: assert property(property_add) 
		$display("add: PASS"); 
	else 
		$display("add: FAIL");

	property property_sub;
		@(posedge clk) disable iff (rst)
		(en && (rss	== 2'b01) && (sub == 1)) |-> sequence_sub;
	endproperty

	sequence sequence_sub;
		##1 acc == $past(acc) - $past(din);
	endsequence

	assert_sub: assert property(property_sub) 
		$display("sub: PASS"); 
	else 
		$display("sub: FAIL");


    // TODO: ADD YOUR ASSERTIONS HERE 


	// ========================================
	// INSTANTIATIONS
	// ========================================
	alu i_dut (
		.clk	(clk),
		.rst	(rst),
		.en		(en ),
		.rss	(rss),
		.sub	(sub),
		.din	(din),
		.acc	(acc)
	);

	alu_cov cov = new();


	// ========================================
	// TESTBENCH EXECUTION
	// ========================================
	initial begin 
		rst = 1;
		clk = 0;

		en  = 1;
		rss = 0;
		sub = 0;
		din = 0;

		#20;
		
		rst = 0;
		
		forever begin
			#5 clk = ~clk;
		end
	end


	initial begin
		
		forever begin
			
			op = new();
			
			assert(op.randomize());
			
			@(posedge clk);
			
			rss = op.rss;
			sub = op.sub;
			din = op.din;
			
			cov.sample();

		end
	end

endmodule : alu_tb
