--------------------------------------------------------------------------------
-- Test bench for the coffeebreak FSM
--------------------------------------------------------------------------------

LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.std_logic_unsigned.all;
USE ieee.numeric_std.ALL;
USE WORK.coffeebreak_pack.ALL;
 
entity tb_coffeebreak_synth is
end tb_coffeebreak_synth;
 
architecture behavior of tb_coffeebreak_synth is
 
	-- Component Declaration for the Unit Under Test (UUT)
 
	component coffeebreak
	port (
		rn        : in  std_logic;
		clk       : in  std_logic;
		eingabe   : in  ...;
		ausgabe   : out ...;
		rueckgeld : out ... );

	end component;

	--Inputs
	signal rn      : std_logic := '0';
	signal clk     : std_logic := '0';
	signal eingabe : ... := nichts;

	--Outputs
	signal ausgabe   : std_logic;
	signal rueckgeld : ...;

	-- Clock period definitions
	constant clk_period : time := 1 us;
	constant clk_offset : time := clk_period*0.75;

	signal td_done : boolean := false;
	
	procedure step_clk is
	begin
		wait for clk_period;
	end;
 
begin
 
	-- Instantiate the Unit Under Test (UUT)
	uut: coffeebreak
	port map (
		rn => rn,
		clk => clk,
		eingabe => eingabe,
		ausgabe => ausgabe,
		rueckgeld => rueckgeld
	);

	-- Clock process definitions
	clk_process : process
	begin
		wait for clk_offset;
		while tb_done = false loop 
			clk <= '0';
			wait for clk_period/2;
			clk <= '1';
			wait for clk_period/2;
		end loop;
		wait;
	end process;
 

	-- Stimulus process
	stim_proc: process
	begin		

	-- hold reset state for 10us.
	wait for 10 us;
		
		rn <= '1';

		step_clk;
		
		eingabe <= fuenfzig;
		
		step_clk;
		
		eingabe <= zehn;
		
		step_clk;
		
		eingabe <= zwanzig;
		
		step_clk; 
		
		eingabe <= zehn;
		
		step_clk;
		
		eingabe <= zwanzig;

		wait for 10*clk_period;

		tb_done <= true;

		wait;
	end process;
end;
