library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

use work.procdefs.all;

entity alu is
	port (
		clk : in  std_logic;
		rst : in  std_logic;
		
		-- enables the alu
		en  : in  std_logic;
		-- result selector
		rss : in std_logic_vector(1 downto 0);
		-- indicates whether to perform a subtraction
		sub : in std_logic;
		-- data input
		din : in std_logic_vector(bit_wd-1 downto 0);
		-- accumulator value
		acc : out std_logic_vector(bit_wd-1 downto 0);
	);
end entity alu;

architecture RTL of alu is
	
	signal int_acc : std_logic_vector(bit_wd-1 downto 0);
	
begin

	acc <= int_acc;
	
	name : process (clk, rst) is
		
		-- adder result
		variable addrs : unsigned(bit_wd-1 downto 0);
		-- adder input
		variable addri : unsigned(bit_wd-1 downto 0);
		
	begin
		if rst = '1' then
			
			int_acc <= (others => '0');	
		
		elsif rising_edge(clk) then
			
			if sub = '1' then
				addri := -- do something
			else
				addri := -- do something else
			end if;
			
			addrs := unsigned(int_acc) + ...
			
			if en = '1' then
				case rss is 
					
				when "00" => 
					-- update accumulator with input data
				
				when "01" => 
					-- update accumulator with adder result
					
				when "10" => 
					-- set upper bits to lower bits of din
					
				when others => 
					-- perform OR of acc and lower bits of din
					
				end case;
			end if;
			
		end if;
	end process name;
	
	

end architecture RTL;
