library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

use work.procdefs.all;

entity regfile is
	port (
		clk  : in  std_logic;
		rst  : in  std_logic;
		-- write enable
		wren : in  std_logic;
		-- register to read
		rd   : in  std_logic_vector(reg_wd-1 downto 0);
		-- data input
		din  : in  std_logic_vector(bit_wd-1 downto 0);
		-- data output
		dout : out std_logic_vector(bit_wd-1 downto 0)
	);
end entity regfile;

architecture RTL of regfile is
	
	type TReg is array ...;
	signal regs : TReg;
	
begin
	
	process (clk, rst) is
	begin
		if rst = '1' then
			
			regs <= (others => std_logic_vector(to_unsigned(0,bit_wd)));
			
		elsif rising_edge(clk) then
			
			if ... then
				-- todo
			end if;
			
		end if;
	end process;
	
	-- multiplexer
	dout <= regs(to_integer(unsigned(rd)));

end architecture RTL;
