
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

use work.procdefs.all;

entity decode is
	port (
		clk : in std_logic;
		rst : in std_logic;
		
		-- instruction from fetch stage
		inst : in std_logic_vector(bit_wd-1 downto 0);
		-- indicates whether instruction is valid
		inst_val : in std_logic;
		
		-- enables the alu
		alu_en : out std_logic;
		-- write enable for the register file
		rf_wr  : out std_logic;
		-- sign extension flag
		exs : out std_logic;
		-- input selection for the alu: '0' use din, '1' use register defined by din
		ins : out std_logic;
		-- indicates whether to perform subtraction
		sub : out std_logic;
		-- result selector
		rss : out std_logic_vector(1 downto 0);
		-- data input for alu
		din : out std_logic_vector(bit_wd/2-1 downto 0);
		
		-- ! indicates whether to perform a branch 
		jmp : out std_logic;
		-- ! indicates whether to write to lower bits of mar
		mal : out std_logic;
		-- ! indicates whether to write to upper bits of mar
		mah : out std_logic
	);
end entity decode;

architecture RTL of decode is
	
begin
	
	name : process (clk, rst) is
		
		variable var_alu_en  : std_logic;
		variable var_rf_wren : std_logic;
		variable var_exs     : std_logic;
		variable var_ins     : std_logic;
		variable var_sub     : std_logic;
		variable var_rss     : std_logic_vector(1 downto 0);
		variable var_jmp     : std_logic;
		variable var_mal     : std_logic;
		variable var_mah     : std_logic;
		
	begin
		
		if rst = '1' then
			
			-- initialize values
			
		elsif rising_edge(clk) then
			
			var_alu_en := '0';
			var_rf_wren := '0';
			var_exs := '0';
			var_ins := '0';
			var_sub := '0';
			var_rss := "00";
			var_jmp := '0';
			var_mal := '0';
			var_mah := '0';
			
			if inst_val = '1' then
				case inst(bit_wd-1 downto bit_wd/2) is
					
					when "0000" =>
						case inst(1 downto 0) is
							
							-- mal
							when "01" =>
								
							-- mah
							when "10" =>
								
							-- jmp
							when "11" =>
								
							-- nop
							when others =>
								null;
						end case;
						
					-- lui
					when "0001" =>
						
					-- ldu
					when "0010" =>
						
					-- lds
					when "0011" =>
						
					-- rac / wac
					when "0100" =>
					
					-- add/sub
					when "0101" =>
						
					-- ori
					when "0110" =>
					
					-- addi
					when "0111" =>
						
					when others =>
						
						null;
										
				end case;
			end if;
			
			din <= inst(bit_wd/2-1 downto 0);
			
			alu_en <= var_alu_en;
			rf_wr <= var_rf_wren;
			exs <= var_exs;
			ins <= var_ins;
			sub <= var_sub;
			rss <= var_rss;
			jmp <= var_jmp;
			mal <= var_mal;
			mah <= var_mah;
				
		end if;
		
	end process name;
	
	
end architecture RTL;
