library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

use work.procdefs.all;

entity ram is
	port (
		clk : in std_logic;
		rst : in std_logic;
		
		--! chip select
		cs   : in std_logic;
		--! write enable
		wren : in std_logic;
		
		--! address
		addr : in  std_logic_vector(bit_wd-1 downto 0);
		--! data input
		di   : in  std_logic_vector(bit_wd-1 downto 0);
		--! data output
		do   : out std_logic_vector(bit_wd-1 downto 0)	
	);
end entity ram;

architecture RTL of ram is
	
	
	
begin
	
	name : process (clk, rst) is
		
		type TRAM is array (0 to 2**(bit_wd)-1) of std_logic_vector(bit_wd-1 downto 0);	
		variable sig_ram : TRAM;
		
	begin
		if rst = '1' then
			do <= (others => '0');
		elsif rising_edge(clk) then
			if cs = '1' then
				if wren = '1' then
					sig_ram(to_integer(unsigned(addr))) := di;
				else
					do <= sig_ram(to_integer(unsigned(addr)));
				end if;
			end if;
		end if;
	end process name;
	

end architecture RTL;
