-- Vhdl test bench created from schematic D:\Work\Designs\hardwaredesign\async_adder.sch - Mon Jun 24 15:27:32 2013
--
-- Notes: 
-- 1) This testbench template has been automatically generated using types
-- std_logic and std_logic_vector for the ports of the unit under test.
-- Xilinx recommends that these types always be used for the top-level
-- I/O of a design in order to guarantee that the testbench will bind
-- correctly to the timing (post-route) simulation model.
-- 2) To use this template as your testbench, change the filename to any
-- name of your choice with the extension .vhd, and use the "Source->Add"
-- menu in Project Navigator to import the testbench. Then
-- edit the user defined section below, adding code to generate the 
-- stimulus for your design.
--
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
library unisim;
use unisim.vcomponents.all;

entity async_adder_async_adder_sch_tb is
end async_adder_async_adder_sch_tb;

architecture behavioral of async_adder_async_adder_sch_tb is 

	-- TODO: Place your adder definition here
	component async_adder
	port( rst   :	in	std_logic;
		  a     :	in	std_logic_vector (15 downto 0); 
		  a_req	:	in	std_logic; 
		  a_ack	:	out	std_logic; 
		  b     :	in	std_logic_vector (15 downto 0); 
		  b_req	:	in	std_logic; 
		  b_ack	:	out	std_logic; 
		  s     :	out	std_logic_vector (15 downto 0); 
		  s_ack	:	in	std_logic; 
		  s_req	:	out	std_logic);
	end component;

	signal rst      :	std_logic := '0';
	signal a	    :	std_logic_vector (15 downto 0);
	signal b	    :	std_logic_vector (15 downto 0);
	signal s	    :	std_logic_vector (15 downto 0);
	signal a_req	:	std_logic := '0';
	signal a_ack	:	std_logic;
	signal b_req	:	std_logic := '0';
	signal b_ack	:	std_logic;
	signal s_ack	:	std_logic := '0';
	signal s_req	:	std_logic;
	

	procedure send(
		signal req : out std_logic; 
		signal ack : in  std_logic; 
		signal din : out std_logic_vector; 
		      data : in  std_logic_vector) is
	begin
		if ( ack /= '0' ) then
			wait until ack = '0';
		end if;
		din <= data after 1 ns;
		req <= '1' after 2 ns;
		wait until ack = '1';
		req <= '0' after 1 ns;
	end procedure;
	
	
	procedure recv(
		signal req : in  std_logic;
		signal ack : out std_logic;
		signal din : in  std_logic_vector;
		      data : out std_logic_vector) is
	begin
		if ( req /= '1' ) then
			wait until req = '1';
		end if;
		wait for 1 ns;
		data := din;
		ack <= '1' after 1 ns;
		wait until req = '0';
		ack <= '0' after 1 ns;
	end procedure;


begin

	uut: async_adder port map(
		b => b, 
		s => s, 
		s_ack => s_ack, 
		s_req => s_req, 
		a_req => a_req, 
		a_ack => a_ack, 
		b_req => b_req, 
		b_ack => b_ack, 
		a => a, 
		rst => rst
	);

	proc_ctrl : process
	begin

		wait for 10 ns;
		rst <= '1';
		wait for 100 ns;
		rst <= '0';
		wait;
	end process;

	proc_a : process
	begin
		wait until rst = '0';
		wait for 8 ns;
		
		send(a_req, a_ack, a, x"0001");
		send(a_req, a_ack, a, x"0002");
		
	end process;
	
	proc_b : process
	begin
		wait for 20 ns;
		wait until rst = '0';
		wait for 10 ns;
		
		send(b_req, b_ack, b, x"1001");
		send(b_req, b_ack, b, x"000A");
		
	end process;
	
	
	proc_s : process
		variable result : std_logic_vector(15 downto 0);
	begin
		wait for 20 ns;
		wait until rst = '0';
		wait for 50 ns;
		
		recv(s_req, s_ack, s, result);
		recv(s_req, s_ack, s, result);
		
	end process;

end;
