%
% This program is free software and not a final version: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as
% published by the Free Software Foundation, either version 2 of the
% License, or (at your option) any later version.
%
% This draft of the script is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details. 
clear all
close all
simulationhappening=1;
pathbatch=uigetdir( '\\CELLMEMBIOPHYS5\shared\Maiara\2020\Glass\201021_RICS &LFCS_DOPC _NTA 10_TFPC 0.01_HA 0.7uM Rehydrated\Control\LFCs');  %Where batch file will be located, indepdend of location of TIF file

global phasemarker bleachcorr imag position pathfile filename  channel num 



if simulationhappening==1
    [filename, pathfile]=uigetfile([pathbatch '\*.mat']);
    load([pathfile '/' filename])
else
    
[filename, pathfile]=uigetfile([pathbatch '/*.czi']);
end

  %insert source, remember to check the batchfile
indexw=1; %1 takes the red channel and 2 the green. Leave 1 if you have just one channel


%PARAMETERS




maxtaucorr=50;  %
bleachcorr=1;  %correction for bleaching
sigmafilter=32;  %
factor=1; % a value of 2 means that 512 pixel lines are rebinned in 256 pixels. 
           %This allows faster calculation. Pixel size must be of course be still much smaller than the PSF

%____________________________________
num=1;

if indexw==1
channel='RED';
end
if indexw==2
    channel='GREEN';
end

% % % % % % % % % for simulation
% % % pixtime=pixeltime;
% % % frametime=linetime;
% % % pixelsize=sizeX/size(frame,2);
% % % length=sizeX;
% % % cdata=frame;
% % % 
% % % % 
% % % % %%%%%%


if simulationhappening==1
    pixtime=pixeltime;
    tiffilename='sim';
    frametime=linetime;
    pixelsize=sizeX/imagesize;
    length=sizeX;
    cdata=frame;
else
 data=bfopen_justinfo([pathfile filename]);
 
 
 
imagemetadata=data{1,2};
allKeys = arrayfun(@char, imagemetadata.keySet.toArray, 'UniformOutput', false);
for i=1:size(allKeys,1)
allKeys{i,2}=imagemetadata.get(allKeys{i,1});
end

tiffilename=imagemetadata.get ('Global Information|Document|Title #1');
pixtime=str2double(imagemetadata.get('Global Information|Image|Channel|LaserScanInfo|PixelTime #1'));
frametime=str2double(imagemetadata.get('Global Information|Image|Channel|LaserScanInfo|FrameTime #1'));
%frametime here is linetime :)
pixelsize=str2double(imagemetadata.get('Global Experiment|AcquisitionBlock|AcquisitionModeSetup|ScalingX #1'))*1000000;
length=pixelsize*str2double(imagemetadata.get('Global Information|Image|SizeX #1'));

% load([pathfile filename]);
% 
%  cdataa=actualdata(1:2000000,:);

cdata=bfopen([pathfile filename(1:end-4) '.tif' ]);
cdata=cdata{1, 1}{1, 1}  ;


end

%%%%for simulations, restart here
%reducing pixel number
Y=double(cdata');
Xa=zeros(size(Y,1)/factor,size(Y,2));
for i=1:size(Y,1)/factor
    %Xa(i,:)=mean(Y(1+(i-1)*factor:i*factor,:),1);
    Xa(i,:)=sum(Y(1+(i-1)*factor:i*factor,:),1);
    
end
Xa=Xa(:,1:floor(size(Xa,2)/100)*100);
%cropping

factory=100;   %100
imag=zeros(size(Xa,1),size(Xa,2)/factory);
for i=1:size(Xa,2)/factory
%     imag(:,i)=mean(Xa(:,1+(i-1)*factory:i*factory),2);
    imag(:,i)=sum(Xa(:,1+(i-1)*factory:i*factory),2);
end

while true
phasemarker='Ld';

hhh=selectionfigure;

% imagesc(log(imag)); 
% 
% if bleachcorr==1
%     title('Bleaching correction is ON!')
%     
% else
%     title('Bleaching correction is OFF!')
% end
% pause(0.001)
% h=imrect(gca,[]);
% wait(h);
% api = iptgetapi(h);
% 
% position= api.getPosition();
   position(3)=position(3)*factory;
position(1)=position(1)*factory;
if  position(1)<0
    position(1)=0;
end
if position(2)<0
    position(2)=0;
end


if position(3)>size(Xa,2)
    position(3)=size(Xa,2);
end

if position(4)>size(Xa,1)
    position(4)=size(Xa,1);
end


position=int32(position);
if rem(position(4),2) ==1
    position(4)=position(4)-1;
end

% batchfile=fopen([pathbatch 'batch.txt'], 'at');
batchfile=fopen([pathbatch '\batch.txt'], 'at');

position
if indexw==1
fprintf(batchfile,'%s;%s; %s;RED; %e; %e; %e; %e; %e; %e; %e; %e; %e; %e; %e\n',pathfile, filename, phasemarker, frametime, pixtime, length, maxtaucorr, bleachcorr, sigmafilter, factor, position );
end
if indexw==2
    fprintf(batchfile,'%s;%s; %s;GREEN; %e; %e; %e; %e; %e; %e; %e; %e; %e; %e; %e\n',pathfile, filename, phasemarker, frametime, pixtime, length, maxtaucorr, bleachcorr, sigmafilter, factor, position );
end

hhh.PaperOrientation='landscape';
print(hhh, [pathbatch '\selections_' filename '_' num2str(num) '_' num2str(rand(1)) '_' phasemarker '.pdf'] , '-dpdf', '-fillpage');
% export_fig (hhh, [pathbatch '\selections_' filename '_' num2str(rand(1))  '.pdf'] )
% export_fig (hhh, [ pathbatch '\selections.pdf'], '-append' )
% saveas(hhh, [ pathbatch '\SELECTION-' filename(1:end-4) '-' num2str(num), 'fig'])
closereq    
clear hhh
filename
num=num+1;


clear channel;
fclose(batchfile);
end
    


