%
% This program is free software and not a final version: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as
% published by the Free Software Foundation, either version 2 of the
% License, or (at your option) any later version.
%
% This draft of the script is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details. 
close all
clear all
fclose all
simulationhappening=1;
%parameters
pskip=0; %2   to remove points from spatial correl.  of the curve with 0 temporal shift
maxxcorr=5; % maximum limit in micrometer for spatial shift for the fit of the correlation 
weighted=1;
blocks=1;
 global Scal
 
 Scal=5;
 
 setthreeddiffusion=0;
settwoddiffusion=1;


 
 
 

[batchfile1, batchdir]=uigetfile('*.txt'); %remember to change the results file
batchfile=fopen([batchdir batchfile1], 'rt'); 



allText = textscan(batchfile,'%s','delimiter','\n');


numberOfLines = length(allText{1});
fclose(batchfile)

batchfile=fopen([batchdir batchfile1], 'rt'); 

linenum=0;
while line ~= -1
 ['Analyzing batch file line ' num2str(linenum+1) ' of ' num2str(numberOfLines)]

 
 
    fid=fopen([batchdir 'results_' num2str(blocks) 'blocks_' date '.txt'], 'at');
    pathpdf= [batchdir 'results_' num2str(blocks) 'blocks_' date '.pdf'];
line=fgets(batchfile);
linenum=linenum+1;
[pathfile,remain]=strtok(line, ';');
[filename,remain]=strtok(remain, ';');
if simulationhappening==1
    load([pathfile '/' filename])
end

% [indexw, remain]=strtok(remain, ';');
% indexw=str2double(indexw);
indexw=1;
[phasemarker,remain]=strtok(remain, ';');
[channel,remain]=strtok(remain,';');
[frametime,remain]=strtok(remain, ';');
frametime=str2double(frametime);
[pixtime,remain]=strtok(remain, ';');
pixtime=str2double(pixtime);
[length,remain]=strtok(remain, ';');
length=str2double(length);
[maxtaucorr,remain]=strtok(remain, ';');
maxtaucorr=str2double(maxtaucorr);
[bleachcorr,remain]=strtok(remain, ';');
bleachcorr=str2double(bleachcorr);
[sigmafilter,remain]=strtok(remain, ';');
sigmafilter=str2double(sigmafilter);
[factor,remain]=strtok(remain, ';');
factor=str2double(factor);
[position1,remain]=strtok(remain, ';');
position(1)=str2double(position1);
[position2,remain]=strtok(remain, ';');
position(2)=str2double(position2);
[position3,remain]=strtok(remain, ';');
position(3)=str2double(position3);
[position4]=strtok(remain, ';');
position(4)=str2double(position4);

if pathfile==-1
    fclose all;
end

[pathfile filename]



% % % % % for simulations

if simulationhappening==0
tiffilename=[filename(1:end-4)];
cdata=bfopen([pathfile tiffilename '.tif' ]);
cdata=cdata{1, 1}{1, 1}  ;
else
    
    cdata=frame;
end


% maxtaucorr=200;
% load([pathfile filename], 'frame')
% cdata=frame(1:end-1,:);
%  maxtaucorr=20;

% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % cdataa=imread([pathfile filename]);
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % if channel(1:3)=='RED'
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % cdata(:,:)=cdataa(:,:,1);
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % end
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % if channel(1:3)=='GRE'
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % %        cdata(:,:)=cdataa(:,:,2); 
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % %     end


%reducing pixel number
Y=double(cdata');
Xa=zeros(size(Y,1)/factor,size(Y,2));
for i=1:size(Y,1)/factor
    %Xa(i,:)=mean(Y(1+(i-1)*factor:i*factor,:),1);
    Xa(i,:)=sum(Y(1+(i-1)*factor:i*factor,:),1);
    
end



% position=[12 124 19585 37];

X=imcrop(Xa,position);
% X=Xa(position(2):position(2)+position(4),position(1):position(1)+position(3));

pixtime=pixtime*factor;

pixsize=factor*length/size(Xa,1);
scanspeed=pixsize/pixtime/factor;

% for z=0:25
   % X=X-2;


X=X(:,1:floor(size(X,2)/100)*100);


%-----

%bleaching correction

if bleachcorr==1;
    linetot=mean(X,1);
    
    starp2=[1  10000  2 ];


options2 = optimset('TolFun',1e-20, 'MaxFunEvals', 4000, 'Maxiter', 4000, 'TolX', 1e-22, 'PlotFcns', @optimplotx);

[fiterg2,resnorm2,residual2,exitflag2,output2,lambda2,J2]=lsqcurvefit(@expsalvo,double(starp2),1:size(linetot,2), linetot' ,[0 0 -10e10],[10e10 10e10 10e10],options2);



close all


hold on









    for i=1:size(linetot,2)
        X(:,i)=(X(:,i)./((abs(expsalvo(fiterg2,i)/expsalvo(fiterg2,1)))^0.5))+(expsalvo(fiterg2,1)-((abs(expsalvo(fiterg2,i)/expsalvo(fiterg2,1)))^0.5)*expsalvo(fiterg2,1));
    end
plot(linetot')
 
end

 plot(mean(X,1)','g')  
if bleachcorr==1
 plot(expsalvo(fiterg2,1:size(linetot,2)),'r+')
end



 saveas(figure(1),[batchdir filename channel num2str(linenum) '_intensity trace.fig']);


%------------------
%spatial filter
% avgX=mean(X,2); %the average line
savedX=X;



% avgX=zeros(size(X,1),1);    %%%%%%%%%%%PROVE PER EXACT N
% for i=1 :size (X,2)
%     X(:,i)=X(:,i)-avgX;
% end
% avgX=mean(X,2);                %%%%%%%%%%%PROVE PER EXACT N

% ---------------

%------------------




%temporal filter 
somma=max(X).*mean(X);
outl=abs(somma-mean(somma))>sigmafilter*std(somma);
%------


blocksize=size(X,2)/blocks;

XcorrCC=zeros(size(X,1),maxtaucorr, blocks);

% larg=size(X,1)-3;
% XcorrCCcrop=zeros(size(X,1)-2,maxtaucorr);

for ii=1:blocks
for i= 1: maxtaucorr
i
    XcorrCC(:,i,ii)=ccorrfunctauline(X(:,1+(ii-1)*blocksize:blocksize*ii)-mean(X(:,1+(ii-1)*blocksize:blocksize*ii),2),i-1,mean(X(:,1+(ii-1)*blocksize:blocksize*ii),2),outl(1,1+(ii-1)*blocksize:blocksize*ii));




end
end
XcorrCC=mean(XcorrCC,3);

if       (pixsize*size(X,1)) > 2*maxxcorr 
    

XcorrCC2=XcorrCC;
clear XcorrCC;
 XcorrCC(:,:)=XcorrCC2(int16(size(XcorrCC2,1)/2)-int16(maxxcorr/pixsize):int16(size(XcorrCC2,1)/2)+int16(maxxcorr/pixsize),:);
end


% amplitude(z+1)=max(XcorrCC(:,2));
% end 


Global=zeros((i*size(XcorrCC,1)),5);
for k=0: i-1
    Global((size(XcorrCC,1))*k+1:(size(XcorrCC,1))*(k+1),1)=-(size(XcorrCC,1)-1)/2:1:(size(XcorrCC,1)-1)/2;
    Global((size(XcorrCC,1))*k+1:(size(XcorrCC,1))*(k+1),2)=frametime*k;
    Global((size(XcorrCC,1))*k+1:(size(XcorrCC,1))*(k+1),3)=XcorrCC(:,k+1);
%     Global((size(XcorrCC,1))*k+1:(size(XcorrCC,1))*(k+1),5)=  (k+1)^-1*(((abs(Global((size(XcorrCC,1))*k+1:(size(XcorrCC,1))*(k+1),1)))+1).^-1);
%     Global((size(XcorrCC,1))*k+1:(size(XcorrCC,1))*(k+1),5)=  (((abs(Global((size(XcorrCC,1))*k+1:(size(XcorrCC,1))*(k+1),1)))+1).^-2);

            Global((size(XcorrCC,1))*k+1:(size(XcorrCC,1))*(k+1),5)=  ones(size(Global((size(XcorrCC,1))*k+1:(size(XcorrCC,1))*(k+1),5),1),1);
end
Global(:,1)=Global(:,1)*pixsize;
% % % % % % % % % % % % % % % % % % % % % % % % % Global((size(XcorrCC,1))/2-9:(size(XcorrCC,1))/2+9,5)=30;
% % % % % % % % % % % % % % % % % % % % % % % % % 
% % % % % % % % % % % % % % % % % % % % % % % % % for ko=1:maxtaucorr-1
% % % % % % % % % % % % % % % % % % % % % % % % % Global(ko*size(XcorrCC,1)+size(XcorrCC,1)/2-9:ko*size(XcorrCC,1)+(size(XcorrCC,1))/2+9,5)=10;
% % % % % % % % % % % % % % % % % % % % % % % % % 
% % % % % % % % % % % % % % % % % % % % % % % % % end

%  Global(find(Global(:,2)<0.001),:)=[];



%remove white noise
% counter=0;
% for j=1:2
%        bbb = find(ismember(Global(1:larg+1,3),max(Global(1:larg+1,3))));
%        Global(bbb,:) = [];
%        counter=counter+size(bbb,1);
% end

%remove G(x,0)


%  Global(1:size(XcorrCC,1),5)=zeros(size(XcorrCC,1),1); %does not fit the first correlation curve (at tau=0)

Global(abs(Global(:,1))<5*pixsize,5)=2; %weight of the top points in every curve
Global(Global(:,2)<3*frametime,5)=5; %weight of  the first 3 G curves
Global(find(Global(:,1)==0 & Global(:,2)==0 )-pskip:find(Global(:,1)==0 & Global(:,2)==0 )+pskip,5)=0; %removes only the top 2*pskip+1 points of the first G curve
Global(Global(:,1)==0 & Global(:,2)==0 ,3)=(Global(find(Global(:,1)==0 & Global(:,2)==0 )+1,3)+Global(find(Global(:,1)==0 & Global(:,2)==0 )+1,3))/2; %set the central point of the first curve equal to average of the 2 neighbours

% starp=[0.22    100  100 0.0001];


options = optimset('TolFun',1e-23, 'MaxFunEvals', 60000, 'Maxiter', 60000, 'TolX', 1e-22, 'PlotFcns', @optimplotx, 'Display', 'off');
Global(:,4)=scanspeed;




% 
% if weighted==0
% [fiterg,resnorm,residual,exitflag,output,lambda,J]=lsqcurvefit(@globalsalvo,starp,[Global(:,1:2) Global(:,4)],Global(:,3), [0.18 1e-1 0.00001 -0.001 ], [0.40 1e4 300 0.001],options);
% exitflag;
% waiste=fiterg(1)
% concentration=fiterg(2)
% D=fiterg(3)
% Dhigh=0;
% end

% if weighted==1 
% 
%     
%     
% 
% [fiterg,resnorm,residual,exitflag,output,lambda,J]=lsqcurvefit(@globalsalvoweigthed,starp,[Global(:,1:2) Global(:,4) Global(:,5)],(Global(:,3).*Global(:,5)), [0.1 1e-1 0.0001 -1e-3 ], [0.40 1e4 18 1e-3],options);
% exitflag;
% waist=fiterg(1)
% concentration=fiterg(2)
% D=fiterg(3)
% Dhigh=1;
% end
% 



close all





%%% long range autocorrelation
[tcorraxis, autocorr,sigmas]=autocorrFCSmultipletau(savedX(1,1:blocksize));
autocorrelationVal=zeros(size(X,1),size(autocorr,2),blocks);
sigmas=zeros(size(sigmas,1), size(sigmas,2), blocks);
clear autocorr 
% AC=zeros(101,1);
% AC1=zeros(201,1);
% autocorrelation=autocorrelationVal;
% totalelinea=sum(savedX,1);
for jj=1:blocks
for ij=1:size(autocorrelationVal,1)

    [~, autocorr,sigmas(:,:,jj)]=autocorrFCSmultipletau(savedX(ij,(jj-1)*blocksize+1:jj*blocksize));   %G(0) is not included

   autocorrelationVal(ij,:,jj)=autocorr;
 clear autocorr
end

end
sigmas=mean(sigmas,3);
autocorrelationVal=mean(autocorrelationVal,3);
% [tcorraxis, ~,sigmas]=(autocorrFCSmultipletau(savedX(1,:)));
tcorraxis=tcorraxis.*frametime;
finalautocorrVal=mean(autocorrelationVal,1);
weigthsfit=abs(finalautocorrVal./sigmas);
weigthsfit=weigthsfit./weigthsfit(1).*1;
Global(1:size(tcorraxis,2),6)=tcorraxis';
Global(1:size(weigthsfit,2),7)=weigthsfit';
Global(1:size(finalautocorrVal.*weigthsfit,2),8)=finalautocorrVal'.*weigthsfit';
% Global(1:size(finalautocorrVal.*weigthsfit,2),8)=zeros(size(finalautocorrVal'.*weigthsfit'));

Global(:,10)=Global(:,8)./Global(:,7);
semilogx(Global(1:end,6),Global(1:end,10),'r+')
hold on
semilogx(Global(Global(:,1)==0,2), (Global(Global(:,1)==0,3)), '+b')




if weighted==1 

    
    

if setthreeddiffusion==1
Dmin=0;
Dmax=300;
end
if settwoddiffusion==1
Dmin=0;
Dmax=50;
end




starp1=[0.22    400  1 0.0001];

starp2=[0.00];
% 
% 
options = optimset('TolFun',1e-15, 'MaxFunEvals', 50000, 'Maxiter', 50000, 'TolX', 1e-15, 'Display', 'off');


if setthreeddiffusion==1
[fitterg,resnorm,residual,exitflag,output,lambda,J]=lsqcurvefit(@globalsalvoweigthedplusslow3d,[starp1 starp2],[Global(:,1:2) Global(:,4) Global(:,5) Global(:,6:7) ], [(Global(:,3).*Global(:,5)) Global(:,8)], [0.18 1e-1 Dmin -1e-4 -1e-4  ], [0.35 1e5 Dmax 1e-4 1e-4 ],options); % [w0_low/high C_low/high D_low/high offset1_low/high offset2_low/high]
end
if settwoddiffusion==1
[fitterg,resnorm,residual,exitflag,output,lambda,J]=lsqcurvefit(@globalsalvoweigthedplusslow,[starp1 starp2],[Global(:,1:2) Global(:,4) Global(:,5) Global(:,6:7) ], [(Global(:,3).*Global(:,5)) Global(:,8)], [0.18 1e-1 Dmin -1e-4 -1e-4  ], [0.35 1e5 Dmax 1e-4 1e-4 ],options); % [w0_low/high C_low/high D_low/high offset1_low/high offset2_low/high]
end
waist=fitterg(1)
concentration=fitterg(2)
D=fitterg(3)





if setthreeddiffusion==1
    ACmat=threeddiffusion([waist*waist*waist*pi^(3/2)*Scal*concentration waist*waist/4/D Scal fitterg(5)],[tcorraxis' ones(size(tcorraxis))']);
end

if settwoddiffusion==1
ACmat=threeddiffusion([waist*waist*pi*concentration waist*waist/4/D 9999 fitterg(5)],[tcorraxis' ones(size(tcorraxis))']);
end

semilogx(Global(1:size(ACmat,1),6),ACmat,'r-')
end


%%%%%%%%%%%%%%%%%%%%%

figure('Position', [10 10 2000 2000])
subplot(1,3,1)
% plot(globalsalvo(fiterg,([Global(1:(maxtaucorr-1)*size(XcorrCC,1),1:2) Global(1:(maxtaucorr-1)*size(XcorrCC,1),4)])),'b')
plot(globalsalvo(fitterg(1:4),([Global(:,1:2) Global(:,4)])),'b')

hold on
% for i=1:2*pskip+1
% Global(Global(:,3)==max(Global(:,3)),3)=0;
% end


% % plot(Global(1:(maxtaucorr-1)*size(XcorrCC,1),3),'r+')
plot(Global(:,3),'r+')

if bleachcorr==1
    title([phasemarker 'Bleaching correction is ON!'])
end
if bleachcorr==0
    title([phasemarker 'Bleaching correction is OFF!'])
end

subplot(1,3,2)

plot(globalsalvo(fitterg(1:4),([Global(1:5*size(XcorrCC,1),1:2) Global(1:5*size(XcorrCC,1),4)])),'b')

hold on
plot(Global(1:5*size(XcorrCC,1),3),'r+')
% plot(Global(1:5*size(XcorrCC,1),5),'k-')

title([pathfile filename channel num2str(linenum)]) ;

 signaltonoise=(max(globalsalvo(fitterg(1:4),([Global(1:size(XcorrCC,1),1:2) Global(1:size(XcorrCC,1),4)]))))/std(Global(size(XcorrCC,1)-5:size(XcorrCC,1)+5,3));
 
 subplot(1,3,3)
 semilogx(tcorraxis,ACmat,'b-')
hold on
semilogx(tcorraxis, finalautocorrVal, 'r+')
% semilogx(frametime:frametime:size(X,2)*frametime, finalautocorr,'go')
 

 saveas(figure(1),[batchdir filename channel num2str(linenum) '.fig']);
saveas(figure(2),[batchdir filename channel num2str(linenum) 'b.fig']);
% saveas(figure(1),[batchdir filename channel num2str(linenum) '_fit.jpg']);
% saveas(figure(2),[batchdir filename channel num2str(linenum) '_fit.jpg']);

export_fig (figure(1), pathpdf, '-append' );
export_fig (figure(2), pathpdf, '-append' );

if signaltonoise < 2
    judgment='NO'
else if signaltonoise < 5
        judgment='~~'
    else
        judgment='OK'
    end
end



if linenum==1
    fprintf(fid, 'ID\t file\t phase\t channel\t w0\t C\t D\t Rel.Brightn.\t Mean I(corrected)\t BleachCorr\t startT\t Vertical Lenght �m\t SignalToNoise\n');
end



    fprintf(fid, '%e\t %s\t %s\t %s\t %e\t %e\t %e\t %e\t %e\t %e\t %e\t %e\t %e\t %s\n', linenum, [pathfile  filename], phasemarker, channel,waist, concentration,   D,  mean(mean(X))/concentration/3.1415/(waist^2)/pixtime/1000, mean(mean(X))/pixtime, bleachcorr, position(1), position(4)*pixsize, signaltonoise, judgment);

fclose(fid);




close all;
clear signaltonoise phasemarker;
clear cdata;
clear J;
clear J2;
clear X;
clear Xa;
clear Y;
clear cdataa;
clear somma;
clear outl;
clear Global;
clear linetot;
clear residual;
clear residual2;
clear XcorrCC;
clear XcorrCC2;
clear line;
clear position;
clear Dhigh;

end


