
%
% This program is free software and not a final version: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as
% published by the Free Software Foundation, either version 2 of the
% License, or (at your option) any later version.
%
% This draft of the script is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details. 

clear all
close all
batchesdir=uigetdir;
listofbatches=dir([batchesdir '/*RICSbatch*']);


for kkk= 1:size(listofbatches,1)


   load([batchesdir '\' listofbatches(kkk,1).name]);
   
lowlim= [0.15 0 0 -0.001 999 ];  %%lower limit for fit:  w0   N   D   offset S

up = [0.6 600 600 0.001 1001];  %upper limit
a1 = [0.3 15 1 0 1000]; %starting parameters
%%% particle concentrations are per default calculated in 2d geometry!



 filter=1;
filterwindow=4;
 
   fid = fopen([batchesdir '\analisi_filter' num2str(filter*filterwindow)  '.txt' ],'a');%where it writes results
pathpdf = [ batchesdir '\analisi_filter' num2str(filter*filterwindow) '.tiff' ];

frame=double(simulationresult(:,:,startframe:endframe));
if rem(size(frame,1),2)==0
   frame=frame(2:end,2:end,:); 
   Use=Use(2:end, 2:end);
end

Usenan=double(Use);
Usenan(Usenan==0)=NaN;

%%%%%%%%%%%%%%%%%%filtering slow dynamics, moving average of 10 frames
if filter==1
    if endframe-startframe+1<filterwindow+1 
   error('Error! You are trying to apply a running average with a window larger than the total amount of frames! \n Remove the filtering by setting filter=0 \n') 
end
end


nonfilteredframe=frame;
totalmean=nanmean(nanmean(nanmean(frame(:,:,:).*Usenan)));
if filter==1 && filterwindow==0
  frame=frame-mean(frame,3);  
end

if filter==1 && filterwindow>0
frame2=zeros(size(frame,1), size(frame,2), size(frame,3)+1-filterwindow);
      for i=filterwindow/2:endframe+1-startframe-filterwindow/2
          blockmean =mean(frame(:,:,i-filterwindow/2+1:i+filterwindow/2),3);
          
       frame2(:,:,i-filterwindow/2+1)=frame(:,:,i)-blockmean;
      
      end    
clear frame
frame=frame2+totalmean;
clear frame2
end

% frame=frame(1:end-1,1:end-1,:);
% Use=Use(1:end-1, 1:end-1);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



ICS2DCorr = arbitrary_salvoV0(frame, Use);


ICS2DCorrCrop = autocropcenter(ICS2DCorr,double(2*(round(2/pixelsize)/2)));  %cropping around the center, obtaining a 2x2�m square
% ICS2DCorrCrop2=ICS2DCorrCrop(1:(size(ICS2DCorrCrop,1)-1),1:(size(ICS2DCorrCrop,2)-1),:);
ICS2DCorrCrop2=ICS2DCorrCrop;
center=(size(ICS2DCorrCrop,1)+1)/2;



%builds corr matrix as a function of x displacement from center, y
%displacement and n (sequence number) see RICS papers Gratton group

corr=zeros(size(ICS2DCorrCrop2,1)*size(ICS2DCorrCrop2,1),6,size(ICS2DCorrCrop2,3));
for k=1:size(ICS2DCorrCrop2,3)
    l=1;
    for i=1:size(ICS2DCorrCrop2,1) %lines

        for j=1:size(ICS2DCorrCrop2,1) %pixels in one line

            corr(l,1,k)=abs(j-center);  %x
            corr(l,2,k)=abs(i-center);  %y
            corr(l,3,k)=linetime;
            
%             if abs(i-center)==0
%             corr(l,3,k)=1;  %n
%             else
%                 corr(l,3,k)=linetime/pixeltime;  %n
%             end
            corr(l,4,k)=ICS2DCorrCrop2(i,j,k);
            corr(l,5,k)=pixelsize;
            corr(l,6,k)=pixeltime;
            
            l=l+1;
        end
    end
end
corr(isnan(corr))=0;
corr(corr==-Inf)=0;
corr(corr==Inf)=0;

%REMOVE shot noise
% befrem=corr(:,4,:);
corr(:,7,:)=ones(size(corr,1),size(corr,3));

% for k=1:shotnoisecorrection
if shotnoisecorrection>0
    for k=1:1:size(corr,3)
    corr((corr(:,1,k)==0 & corr(:,2,k)==0),7,k)=0;
    
corr((corr(:,1,k)==0 & corr(:,2,k)==0),4,k)=(corr(find(corr(:,1,k)==0 & corr(:,2,k)==0)-1,4,k)+corr(find(corr(:,1,k)==0 & corr(:,2,k)==0)+1,4,k))/2;
    
    end
end


% if shotnoisecorrection>1
%     err
% end

%%%%%%%%%%%


avgcorr=mean(corr,3);
avgcorr(:,7)=corr(:,7,1);
weightsfornonw=avgcorr(:,7);

% befremavg=mean(befrem,3);
% befremavg((befremavg==max(befremavg)))=[];
% avgcorr(:,7)=(std(corr(:,4,:),1,3)./mean(corr(:,4,:),3)).^-1; %weigths
% avgcorr(1:end-1,7)=((diff(avgcorr(:,4)))).^2*0.01;
% avgcorr(2330:2370,7)=avgcorr(2330:2370,7)./10;
avgcorr(:,7)=avgcorr(:,7).*(((avgcorr(:,1)+1)).^-2).*(((avgcorr(:,2)+1)).^-1);
%  avgcorr(:,7)=avgcorr(:,7).*(((avgcorr(:,2)+1)).^-1);

% avgcorr((avgcorr(:,1)>7 & avgcorr(:,2)>-1) ,7)=0;
% 



        

                               %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% if filter ==1     %%%%calculating non filtered data for N calculation and this is weighted!
%                                    nonfilteredICS2DCorr = corrfunc(nonfilteredframe);
% %%%% all this is not working!!!%%%%
% nonfilteredICS2DCorrCrop = autocropcenter(nonfilteredICS2DCorr,double(2*(round(2/pixelsize)/2)));  %cropping around the center, obtaining a 2x2�m square
% % ICS2DCorrCrop2=ICS2DCorrCrop(1:(size(ICS2DCorrCrop,1)-1),1:(size(ICS2DCorrCrop,2)-1),:);
% nonfilteredICS2DCorrCrop2=nonfilteredICS2DCorrCrop;
% nonfilteredcenter=(size(nonfilteredICS2DCorrCrop,1)+1)/2;
% 
% 
% %builds corr matrix as a function of x displacement from center, y
% %displacement and n (sequence number) see RICS paper
% 
% nonfilteredcorr=zeros(size(nonfilteredICS2DCorrCrop2,1)*size(nonfilteredICS2DCorrCrop2,1),6,size(nonfilteredICS2DCorrCrop2,3));
% for k=1:size(nonfilteredICS2DCorrCrop2,3)
%     l=1;
%     for i=1:size(nonfilteredICS2DCorrCrop2,1) %lines
% 
%         for j=1:size(nonfilteredICS2DCorrCrop2,1) %pixels in one line
% 
%             nonfilteredcorr(l,1,k)=abs(j-nonfilteredcenter);  %x
%             nonfilteredcorr(l,2,k)=abs(i-nonfilteredcenter);  %y
%             nonfilteredcorr(l,3,k)=linetime;
% %             if abs(i-center)==0
% %             corr(l,3,k)=1;  %n
% %             else
% %                 corr(l,3,k)=linetime/pixeltime;  %n
% %             end
%             nonfilteredcorr(l,4,k)=nonfilteredICS2DCorrCrop2(i,j,k);
%             nonfilteredcorr(l,5,k)=pixelsize;
%             nonfilteredcorr(l,6,k)=pixeltime;
%             l=l+1;
%         end
%     end
% end
% 
% 
% %REMOVE shot noise
% nonfilteredbefrem=nonfilteredcorr(:,4,:);
% 
% 
% nonfilteredcorr(:,7,:)=ones(size(nonfilteredcorr,1),size(nonfilteredcorr,3));
% if shotnoisecorrection>0
%  for k=1:1:size(nonfilteredcorr,3)
%     nonfilteredcorr(nonfilteredcorr(:,4,k)==max(nonfilteredcorr(:,4,k)),7,k)=0;
% nonfilteredcorr(nonfilteredcorr(:,4,k)==max(nonfilteredcorr(:,4,k)),4,k)=(nonfilteredcorr(find(nonfilteredcorr(:,4,k)==max(nonfilteredcorr(:,4,k)))-1,4,k)+nonfilteredcorr(find(nonfilteredcorr(:,4,k)==max(nonfilteredcorr(:,4,k)))+1,4,k))/2;
% 
%     end
% end
% 
% 
% % if shotnoisecorrection>1
% %     err
% % end
% 
% %%%%%%%%%%%
% 
% 
% nonfilteredavgcorr=mean(nonfilteredcorr,3);
% nonfilteredavgcorr(:,7)=nonfilteredcorr(:,7,1);
% nonfilteredbefremavg=mean(nonfilteredbefrem,3);
% % avgcorr(:,7)=(std(corr(:,4,:),1,3)./mean(corr(:,4,:),3)).^-1; %weigths
% % avgcorr(1:end-1,7)=((diff(avgcorr(:,4)))).^2*0.01;
% nonfilteredavgcorr(:,7)=nonfilteredavgcorr(:,7).*(((nonfilteredavgcorr(:,1)+1)).^-2).*(((nonfilteredavgcorr(:,1)+1)).^-2);
% % avgcorr(2330:2370,7)=avgcorr(2330:2370,7)./10;
% 
%                                
%                                
%                                end
                               %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

                               
%FITTING EVERY CORRELATION
fiterg=zeros(size(frame,3),5);
fiterg5=fiterg;
% options = optimset('Display','off');
options = optimset('TolFun',1e-19, 'MaxFunEvals', 500, 'Maxiter', 500, 'TolX', 1e-19, 'Display','off');
brightness_eachframe=zeros(size(corr,3),1);
brightness_eachframe_nw=brightness_eachframe;
   h = waitbar(0,'Fitting each frame�s 2D correlation...');
for i=1:size(corr,3)
    if ishandle(h)
     waitbar(i/size(corr,3),h)
     else
         break
     end
    
  try     
[fiterg(i,:),resnorm,residual,exitflag,output,lambda,J]=lsqcurvefit(@globalsalvo3dricsweighted,a1,[corr(:,1:3,i) corr(:,5:6,i) avgcorr(:,7)],(corr(:,4,i).*avgcorr(:,7)), lowlim, up,options); 

        [fiterg5(i,:),resnorm,residual,exitflag,output,lambda,J]=lsqcurvefit(@globalsalvo3dricsweighted,a1,[corr(:,1:3,i) corr(:,5:6,i) weightsfornonw],(corr(:,4,i).*weightsfornonw), lowlim, up,options); %not weighted
  catch

    fiterg(i,:)=zeros(1,5);
     fiterg5(i,:)=zeros(1,5);
     fprintf('Cannot fit!!!/n')


  end
  

brightness_eachframe(i)=(nanmean(nanmean(frame(:,:,i).*Usenan))/pixeltime)/(fiterg(i,2))/1000; %in  KHz, I divided by N (not C)
brightness_eachframe_nw(i)=(nanmean(nanmean(frame(:,:,i).*Usenan))/pixeltime)/(fiterg5(i,2))/1000; %  in KHz

end
close (h)  


scrsz = get(0,'ScreenSize');



%%% added to check each frame correlation fit

% for j=1:endframe
%figure (36)
% plot(corr(:,4,j),'r+')
%plot(befrem(:,1,j),'r+')
%hold on
%plot(globalsalvo3drics(fiterg(j,:),[corr(:,1:3,j) corr(:,5:6,j)]))
%% plot(globalsalvo3drics(a1,[corr(:,1:3,i) corr(:,5:6,i)]),'g-')
%axis([size(corr,1)/2-2*size(ICS2DCorrCrop,1) size(corr,1)/2+2*size(ICS2DCorrCrop,1) min(corr(:,4,j)) max(corr(:,4,j))])
%title(['Fitting for frame ' num2str(j)])
%pause
%close 36
% end

 
 %%%-------------------------






fig2=figure('OuterPosition',[1 1 scrsz(3) scrsz(4)])

subplot(2,3,1)
% figure('OuterPosition',[1 scrsz(4)/2 scrsz(3)/3 scrsz(4)/2], 'Name','Fitting for first frame')


z=1;
plot(corr(:,4,z),'r+')
% plot(befrem(:,1,z),'r+')
hold on
plot(globalsalvo3drics(fiterg(z,:),[corr(:,1:3,z) corr(:,5:6,z)]),'b-')
plot(globalsalvo3drics(fiterg5(z,:),[corr(:,1:3,z) corr(:,5:6,z)]),'g-') %not weighted

% plot(globalsalvo3drics(a1,[corr(:,1:3,i) corr(:,5:6,i)]),'g-')

yscal=0.3*(max(globalsalvo3drics(fiterg(z,:),[corr(:,1:3,z) corr(:,5:6,z)]))-min(globalsalvo3drics(fiterg(z,:),[corr(:,1:3,z) corr(:,5:6,z)])));
axis([size(corr,1)/2-3*size(ICS2DCorrCrop,1) size(corr,1)/2+2*size(ICS2DCorrCrop,1) min(globalsalvo3drics(fiterg(z,:),[corr(:,1:3,z) corr(:,5:6,z)]))-yscal max(globalsalvo3drics(fiterg(z,:),[corr(:,1:3,z) corr(:,5:6,z)]))+yscal])
title('Fitting for first frame, green is not weighted')
  if filter==1 && filterwindow>0
  fiterg(:,2)=fiterg(:,2)/filterwindow*(filterwindow-1); % rescaling from J. Hendrix´s paper (ARICS)
fiterg5(:,2)=fiterg5(:,2)/filterwindow*(filterwindow-1); %AC rescaling from Hendrix´s paper
brightness_eachframe(:)= brightness_eachframe(:).*filterwindow./(filterwindow-1);%in  KHz, I divided by N (not C)
brightness_eachframe_nw(:)=brightness_eachframe_nw(:).*filterwindow./(filterwindow-1);
  end


meann=(mean(ICS2DCorrCrop,3));

meann(center,center)=0;


%all weighted
finalparameters=mean(fiterg,1);
finalparameters2=trimmean(fiterg,15,1);
Fitted_w0=finalparameters2(1);
Fitted_D=finalparameters2(3);

% Particle_concentration=finalparameters2(2)/3.1415^(3/2)/finalparameters2(1)^3/finalparameters2(5); % 3d
 Particle_concentration=finalparameters2(2)/3.1415/finalparameters2(1)^2; % 2d





%%%%%%%%%%%%%%%%%%%% Fitting the average correlation



[fiterg2,~,~,~,~,~,~]=lsqcurvefit(@globalsalvo3dricsweighted,a1,[avgcorr(:,1:3) avgcorr(:,5:6) avgcorr(:,7)],(avgcorr(:,4).*avgcorr(:,7)), lowlim, up,options); 
[fiterg3,resnorm,residual,exitflag,output,lambda,J]=lsqcurvefit(@globalsalvo3dricsweighted,a1,[avgcorr(:,1:3) avgcorr(:,5:6) weightsfornonw],(avgcorr(:,4).*weightsfornonw), lowlim, up,options); 
% if filter==1
%     [fiterg4,resnorm,residual,exitflag,output,lambda,J]=lsqcurvefit(@globalsalvo3dricsweighted,a1,[nonfilteredavgcorr(:,1:3) nonfilteredavgcorr(:,5:6) nonfilteredavgcorr(:,7)],(nonfilteredavgcorr(:,4).*nonfilteredavgcorr(:,7)), lowlim, up,options); 
% [fiterg6,resnorm,residual,exitflag,output,lambda,J]=lsqcurvefit(@globalsalvo3dricsweighted,a1,[nonfilteredavgcorr(:,1:3) nonfilteredavgcorr(:,5:6) weightsfornonw],(nonfilteredavgcorr(:,4).*weightsfornonw), lowlim, up,options); 
% end


 subplot(2,3,2) 


plot(avgcorr(:,4),'r+')
% plot(befremavg,'ko')
% plot(befrem(:,1,z),'r+')

hold on
plot(globalsalvo3drics(fiterg3(1,:),[avgcorr(:,1:3) avgcorr(:,5:6)]),'g-')   %not weighted
plot(globalsalvo3drics(fiterg2(1,:),[avgcorr(:,1:3) avgcorr(:,5:6) ]),'b-')



yscal=0.3*(max(globalsalvo3drics(fiterg2(1,:),[avgcorr(:,1:3) avgcorr(:,5:6) ]))-min(globalsalvo3drics(fiterg2(1,:),[avgcorr(:,1:3) avgcorr(:,5:6) ])));
axis([size(corr,1)/2-3*size(ICS2DCorrCrop,1) size(corr,1)/2+2*size(ICS2DCorrCrop,1) min(globalsalvo3drics(fiterg2(1,:),[avgcorr(:,1:3) avgcorr(:,5:6) ]))-yscal max(globalsalvo3drics(fiterg2(1,:),[avgcorr(:,1:3) avgcorr(:,5:6) ]))+yscal])

title('Fitting for the average (Global) correlation (blue weighted fit, green not weighted fit)')

if filter==1 && filterwindow>0
fiterg2(:,2)=fiterg2(:,2)/filterwindow*(filterwindow-1); % rescaling from J. Hendrix´s paper (ARICS)
fiterg3(:,2)=fiterg3(:,2)/filterwindow*(filterwindow-1); % rescaling from J. Hendrix´s paper (ARICS)
end

Global_D=fiterg2(3);
% Global_concentration=fiterg2(2)/(3.1415^(3/2)*fiterg3(5)*fiterg2(1)^3); %3d
Global_concentration=fiterg2(2)/(3.1415*fiterg2(1)^2);  %2d
diffusion_time=fiterg2(1)^2/4/Global_D*1000;


Global_waist=fiterg2(1);
Global_brightness=(nanmean(nanmean(frame(:,:,i).*Usenan))/pixeltime)/fiterg2(2)/1000; %  in KHz

Global_D_nonw=fiterg3(3);
% Global_concentration_nonw=fiterg3(2)/(3.1415^(3/2)*fiterg3(5)*fiterg3(1)^3); %3d
Global_concentration_nonw=fiterg3(2)/(3.1415*fiterg3(1)^2);  %2d

Global_waist_nonw=fiterg3(1);
Global_brightness_nw=(nanmean(nanmean(frame(:,:,i).*Usenan))/pixeltime)/fiterg3(2)/1000; % in KHz


% if filter==1
% Global_concentration_nonfiltered=0%fiterg4(2)/(3.1415^(3/2)*fiterg2(5)*fiterg2(1)^3);  %%%using w0 from filtered data
% % Global_concentration_nonw_nonfiltered=fiterg6(2)/(3.1415^(3/2)*fiterg3(5)*fiterg3(1)^3);  %3d
% Global_concentration_nonw_nonfiltered=0%fiterg6(2)/(3.1415*fiterg3(1)^2);  %2d
% 
% end

% if abs((Global_D - Fitted_D))/Global_D > 0.1 || abs(Global_waist-Fitted_w0)/Fitted_w0 > 0.1
%     
%     figure (99)
%  
%     image(cdata);
%     pause
%     close 99
%     
% end
    
%%%%%%%%%%%%%%%%%%%


%%%% PLOT to check weights
% figure
% plot((avgcorr(:,4).*avgcorr(:,7)),'r+')
% hold on
% plot(globalsalvo3dricsweighted(fiterg2(1,:),[avgcorr(:,1:3) avgcorr(:,5:6) avgcorr(:,7)]),'b-')
%%%%%%%%%%%%%%%%%%%%%

%%%% SLOW CORRELATION
if TICS_anal==1
GtDiff = tics(frame,frametime);
diffCoeff = difffit(GtDiff(1:10,1),GtDiff(1:10,2));
Slow_D = (fiterg2(1))^2/(4*diffCoeff(2))
end

%%%%%%%%%%% FCS for each pixel
%                            pixelfcs=zeros(endframe,2,size(frame,1)^2);
%                            numbermatrixfromfcs=zeros(size(frame,1),size(frame,1));
%                            brightnessmatrixfromfcs=zeros(size(frame,1),size(frame,1));
%                          h = waitbar(0,'Calculating FCS curves for each pixel...');
%                                     for i=1:size(frame,1)
%     for j=1:size(frame,1)
%         meanij=mean(frame(i,j,:),3);
%         AC=(xcorr(frame(i,j,:)-meanij, endframe, 'unbiased'))./mean(frame(i,j,:),3)^2;
%         pixelfcs(:,2,i+(j-1)*size(frame,1))=AC(1,1,endframe+1:size(AC,3)-1);
%         numbermatrixfromfcs(i,j)=(AC(1,1,endframe+1))^-1;
%         brightnessmatrixfromfcs(i,j)=(AC(1,1,endframe+1))*mean(frame(i,j,:),3);
% 
% 
% 
%         
%     end
%     if ishandle(h)
%      waitbar(i/pixelnumb)
%      else
%          break
% end
%         
% end
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%

% Particle_concentrations=fiterg(:,2)./3.1415^(3/2)./(fiterg(:,1).^3)./fiterg(:,5);  %3d
% Particle_concentrations_nw=fiterg5(:,2)./3.1415^(3/2)./(fiterg5(:,1).^3)./fiterg5(:,5);  %3d

Particle_concentrations=fiterg(:,2)./3.1415./(fiterg(:,1).^2);  %2d
Particle_concentrations_nw=fiterg5(:,2)./3.1415./(fiterg5(:,1).^2);  %2d
subplot(2,3,3)


plot(avgcorr(:,4),'ko')
% plot(befremavg,'ko')

hold on

if filter==1
plot(globalsalvo3drics(fiterg3(1,:)*filterwindow/(filterwindow-1),[avgcorr(:,1:3) avgcorr(:,5:6)]),'g-')   %not weighted
plot(globalsalvo3drics(fiterg2(1,:)*filterwindow/(filterwindow-1),[avgcorr(:,1:3) avgcorr(:,5:6) ]),'b-')
fiterg2(1,3)=fiterg2(1,3)/1000000;
plot(globalsalvo3drics(fiterg2(1,:)*filterwindow/(filterwindow-1),[avgcorr(:,1:3) avgcorr(:,5:6) ]),'r-')
fiterg2(1,3)=fiterg2(1,3)*1000000;
else
    plot(globalsalvo3drics(fiterg3(1,:),[avgcorr(:,1:3) avgcorr(:,5:6)]),'g-')   %not weighted
plot(globalsalvo3drics(fiterg2(1,:),[avgcorr(:,1:3) avgcorr(:,5:6) ]),'b-')
fiterg2(1,3)=fiterg2(1,3)/1000000;
plot(globalsalvo3drics(fiterg2(1,:),[avgcorr(:,1:3) avgcorr(:,5:6) ]),'r-')
fiterg2(1,3)=fiterg2(1,3)*1000000;
end



yscal=0.3*(max(globalsalvo3drics(fiterg2(1,:),[avgcorr(:,1:3) avgcorr(:,5:6) ]))-min(globalsalvo3drics(fiterg2(1,:),[avgcorr(:,1:3) avgcorr(:,5:6) ])));
axis([size(corr,1)/2-8*size(ICS2DCorrCrop,1) size(corr,1)/2+2*size(ICS2DCorrCrop,1) min(globalsalvo3drics(fiterg2(1,:),[avgcorr(:,1:3) avgcorr(:,5:6) ]))-yscal max(globalsalvo3drics(fiterg2(1,:),[avgcorr(:,1:3) avgcorr(:,5:6) ]))+yscal])

title('Fitting for the average (Global) correlation (blue weighted fit, green not weighted fit)')

% % % % % % % % title('Multimerization plot weighted')
% % % % % % % % 
% % % % % % % % 
% % % % % % % % 
% % % % % % % % clear avgI
% % % % % % % % avgI(1,:)=mean(mean(frame));
% % % % % % % %   plot(avgI/avgI(1,1),fiterg(:,2)/fiterg(1,2),'r+')
% % % % % % % %   
% % % % % % % % %     plot(avgI/avgI(1,1),Particle_concentrations/Particle_concentrations(1,1),'r+')
% % % % % % % % hold on
% % % % % % % %  xpoints=0:0.01:1;
% % % % % % % %  plot([0 10],[0 10],'b-')
% % % % % % % %   plot(xpoints,1./((1/2)+(1./(2.*xpoints))),'g-') %dimer
% % % % % % % %     plot(xpoints,1./((2/3)+(1./(3.*xpoints))),'k-') %trimer
% % % % % % % % xlabel('I Fraction','FontSize',12)
% % % % % % % % ylabel('Concentration Fraction','FontSize',12)
% % % % % % % % maxaxe=max(max(avgI./avgI(1,1)),max(fiterg(:,2)./fiterg(1,2)));
% % % % % % % % 
% % % % % % % % axis([0 maxaxe 0 maxaxe])
%%%%%%%%%%%%%
subplot(2,3,4)

plot(fiterg(:,1))
hold on
plot([startframe endframe],[mean(fiterg(:,1)) mean(fiterg(:,1))], 'r-')
plot([startframe endframe],[mean(fiterg(:,1))+std(fiterg(:,1)) mean(fiterg(:,1))+std(fiterg(:,1))], 'g--')
plot([startframe endframe],[mean(fiterg(:,1))-std(fiterg(:,1)) mean(fiterg(:,1))-std(fiterg(:,1))], 'g--')
xlabel('Frames','FontSize',12)
ylabel('w0','FontSize',12)

title('Waist/Focusing weighted')
%%%%%%%%%%
subplot(2,3,5)
title('Particle brightness in each frame weighted')
plot(brightness_eachframe)
hold on
plot([startframe endframe],[mean(brightness_eachframe) mean(brightness_eachframe)], 'r-')
plot([startframe endframe],[mean(brightness_eachframe)+std(brightness_eachframe) mean(brightness_eachframe)+std(brightness_eachframe)], 'g--')
plot([startframe endframe],[mean(brightness_eachframe)-std(brightness_eachframe) mean(brightness_eachframe)-std(brightness_eachframe)], 'g--')
xlabel('Frames','FontSize',12)
ylabel('Particle brightness, photons/mol/time (KHz)','FontSize',12) 
%%%%%%%%%%%
subplot(2,3,6)

plot(fiterg(:,2))
hold on
plot([startframe endframe],[mean(fiterg(:,2)) mean(fiterg(:,2))], 'r-')
plot([startframe endframe],[mean(fiterg(:,2))+std(fiterg(:,2)) mean(fiterg(:,2))+std(fiterg(:,2))], 'g--')
plot([startframe endframe],[mean(fiterg(:,2))-std(fiterg(:,2)) mean(fiterg(:,2))-std(fiterg(:,2))], 'g--')
title('Particles in focal volume vs. Frame weighted')
%%%%%%%%%%%%%%%

% %%%%%%%%%%% N & B
% if filter==0
% figure('OuterPosition',[1 200 scrsz(3)/3 scrsz(4)/2], 'Name','Average Intensity')
% meanframe=mean(frame1,3);
% varianceframe=var(frame1,1,3);
% imagesc(meanframe)
% 
% figure('OuterPosition',[scrsz(3)/3 200 scrsz(3)/3 scrsz(4)/2], 'Name','Brightness Map')
% brightnessmap=(varianceframe-meanframe)./meanframe;
% imagesc(brightnessmatrixfromfcs)
% % imagesc(brightnessmap)
% 
% figure('OuterPosition',[2*scrsz(3)/3 200 scrsz(3)/3 scrsz(4)/2], 'Name','Number Map')
% number=(meanframe.^2)./(varianceframe-meanframe);
% imagesc(numbermatrixfromfcs)
% % imagesc(number)
% % mobilitymap=varianceframe./meanframe;
% % figure
% % imagesc(mobilitymap)
% figure
% % [meanbrightnessnb rect3]=imcrop(brightnessmatrixfromfcs);
% [meanbrightnessnb rect3]=imcrop(brightnessmap);
% BrightnessfromNandB=mean(mean(meanbrightnessnb))
% end
%%%%%%%%%%%
  
export_fig (pathpdf, '-append' )
savefig([batchesdir '/' num2str(2*kkk-1) '.fig']) 

 fig3=figure('units','normalized','outerposition',[0 0 1 1])
  mTextBox = uicontrol('style','text');
 set(mTextBox, 'Position', [113   600   850    22])
 set(mTextBox,'String',[pathname filename])% '|Average waist='])% num2str(finalparameters2(1) '\n Average C=' num2str(Particle_concentration)])
 
 
 mTextBox = uicontrol('style','text');
 set(mTextBox, 'Position', [113   575   150    22])
 set(mTextBox,'String',['Average D=' num2str(Fitted_D)])% '|Average waist='])% num2str(finalparameters2(1) '\n Average C=' num2str(Particle_concentration)])
 
 mTextBox2 = uicontrol('style','text');
 set(mTextBox2, 'Position', [113   550   150    22])
 set(mTextBox2,'String',['Average waist=' num2str(finalparameters2(1))])
 
 mTextBox3 = uicontrol('style','text');
 set(mTextBox3, 'Position', [113   525   150    22])
 set(mTextBox3,'String',['Average C=' num2str(Particle_concentration)])
 
 
 
  mTextBox3 = uicontrol('style','text');
 set(mTextBox3, 'Position', [113   500   150    22])
 set(mTextBox3,'String',['Average B=' num2str(mean(brightness_eachframe))])
 

  mTextBox4 = uicontrol('style','text');
 set(mTextBox4, 'Position', [280   575   150    22])
 set(mTextBox4,'String',['GLOBAL D=' num2str(Global_D)])% '|Average waist='])% num2str(finalparameters2(1) '\n Average C=' num2str(Particle_concentration)])
 
 mTextBox2 = uicontrol('style','text');
 set(mTextBox2, 'Position', [280   550   150    22])
 set(mTextBox2,'String',['GLOBAL waist=' num2str(Global_waist)])
 
 mTextBox3 = uicontrol('style','text');
 set(mTextBox3, 'Position', [280   525   150    22])
 set(mTextBox3,'String',['GLOBAL C=' num2str(Global_concentration)])
 
   mTextBox3 = uicontrol('style','text');
 set(mTextBox3, 'Position', [280   500   150    22])
 set(mTextBox3,'String',['GLOBAL B=' num2str(Global_brightness)])
 
   mTextBox4 = uicontrol('style','text');
 set(mTextBox4, 'Position', [280   475   150    22])
 set(mTextBox4,'String',['nonw D=' num2str(Global_D_nonw)])% '|Average waist='])% num2str(finalparameters2(1) '\n Average C=' num2str(Particle_concentration)])
 
 mTextBox2 = uicontrol('style','text');
 set(mTextBox2, 'Position', [280   450   150    22])
 set(mTextBox2,'String',['nonw waist=' num2str(Global_waist_nonw)])
 
 mTextBox3 = uicontrol('style','text');
 set(mTextBox3, 'Position', [280   425   150    22])
 set(mTextBox3,'String',['nonw C=' num2str(Global_concentration_nonw)])
  
 mTextBox3 = uicontrol('style','text');
 set(mTextBox3, 'Position', [280   400   150    22])
 set(mTextBox3,'String',['GLOBAL B nw=' num2str(Global_brightness_nw)])
 
%  
%  if filter==1
%   mTextBox3 = uicontrol('style','text');
%  set(mTextBox3, 'Position', [280   375   150    22])
%  set(mTextBox3,'String',['nonw nonFiltC=' num2str(Global_concentration_nonw_nonfiltered)])
%  
%   mTextBox3 = uicontrol('style','text');
%  set(mTextBox3, 'Position', [280   350   150    22])
%  set(mTextBox3,'String',['nonFilt C=' num2str(Global_concentration_nonfiltered)])
%  end
 
   mTextBox4 = uicontrol('style','text');
 set(mTextBox4, 'Position', [280+170   575   150    22])
 set(mTextBox4,'String',['Frame 1 D=' num2str(mean(fiterg(1:1,3)))])% '|Average waist='])% num2str(finalparameters2(1) '\n Average C=' num2str(Particle_concentration)])
 
 mTextBox2 = uicontrol('style','text');
 set(mTextBox2, 'Position', [280+170   550   150    22])
 set(mTextBox2,'String',['Frame 1 waist=' num2str(mean(fiterg(1:1,1)))])
 
 mTextBox3 = uicontrol('style','text');
 set(mTextBox3, 'Position', [280+170   525   150    22])
 set(mTextBox3,'String',['Frame 1 C=' num2str(mean(Particle_concentrations(1:1,1)))])
 
    mTextBox3 = uicontrol('style','text');
set(mTextBox3, 'Position', [280+170   500   150    22])
 set(mTextBox3,'String',['Frame 1 B=' num2str((brightness_eachframe(1)))])
 
    mTextBox4 = uicontrol('style','text');
 set(mTextBox4, 'Position', [280+170   475   150    22])
 set(mTextBox4,'String',['Frame 1 D nw=' num2str(mean(fiterg5(1:1,3)))])% '|Average waist='])% num2str(finalparameters2(1) '\n Average C=' num2str(Particle_concentration)])
 
 mTextBox2 = uicontrol('style','text');
 set(mTextBox2, 'Position', [280+170   450   150    22])
 set(mTextBox2,'String',['Frame 1 waist nw=' num2str(mean(fiterg5(1:1,1)))])
 
 mTextBox3 = uicontrol('style','text');
 set(mTextBox3, 'Position', [280+170   425   150    22])
 set(mTextBox3,'String',['Frame 1 C nw=' num2str(mean(Particle_concentrations_nw(1:1,1)))])
 
 subplot(3,2,1)
 s=surf(meann);
axis tight
colormap(jet)

xlabel('\eta','FontSize',12)
ylabel('\xi','FontSize',12)
zlabel('r(\xi,\eta)','FontSize',12)
set(s,'LineStyle','none')
title('Cropped Mean Spatial Autocorrelation Function')


if filter==1
subplot(3,2,2)

plot(squeeze(nanmean(nanmean(nonfilteredframe.*Usenan)))/pixeltime)
hold on
plot([startframe endframe],[nanmean(squeeze(nanmean(nanmean(nonfilteredframe.*Usenan))))/pixeltime nanmean(squeeze(nanmean(nanmean(nonfilteredframe.*Usenan))))/pixeltime], 'r-')
title('Intensity per time (in focal spot) vs. Frame')
else
 subplot(3,2,2)

plot(squeeze(nanmean(nanmean(frame.*Usenan)))/pixeltime)
hold on
plot([startframe endframe],[nanmean(squeeze(nanmean(nanmean(frame.*Usenan))))/pixeltime nanmean(squeeze(nanmean(nanmean(frame.*Usenan))))/pixeltime], 'r-')
title('Intensity per time vs. Frame')   

end


subplot(3,2,4)
plot(fiterg(:,3))
hold on
plot([startframe endframe],[mean(squeeze(mean(fiterg(:,3)))) mean(squeeze(mean(fiterg(:,3))))], 'r-')
title('D vs. frame')

subplot(3,2,5)

imagesc(sum(frame,3))



subplot(3,2,6)

imagesc(sum(frame.*Usenan,3))



if TICS_anal==0
    Slow_D=0
end
export_fig (pathpdf, '-append' )
savefig([batchesdir '/' num2str(2*kkk) '_filter=' num2str(filter*filterwindow) '.fig']) 


try
    note{1,1};
catch
   note{1,1}=' ';
end

if ftell(fid) <1
fprintf(fid, 'ID\t FileName\t Note\t Avg D\t Avg w0\t Avg C\t  Avg Brightness\t Global D\t diff.time\t Glob w0\t Glob C\t Glob B\t Glob D nw\t Glob w0 nw\t Glob C nw\t Glob B nw\t Frame1 D\t Frame1 w0\t Frame1 C\t Frame1 B\t Frame1 D nw\t Frame1 w0 nw\t Frame1 C nw\t Mean I selection\t  Mean Frame1\t Mean Frame1 SELECTION\n');
% fprintf(fid, '\t \t �m�/s \t �m\t molecules/�m�\t kHz/mol\t �m�/s\t �m\t mole/�m�\t kHz/mol\t �m�/s\t �m\t mol/�m�\t kHz/mol\t �m�/s\t �m\t mol/�m�\t kHz/mol\t �m�/s\t �m\t mol/�m�\t kHz\t kHz\n');

end
fprintf(fid,'%e\t %s\t %s\t %e\t %e\t %e\t %e\t %e\t %e\t %e\t %e\t %e\t %e\t %e\t %e\t %e\t %e\t %e\t %e\t %e\t %e\t %e\t %e\t %e\t %e\t %e\n',kkk, [pathname filename], note{1,1}, Fitted_D, finalparameters2(1),   Particle_concentration, mean(brightness_eachframe), Global_D, diffusion_time, Global_waist, Global_concentration, Global_brightness, Global_D_nonw,Global_waist_nonw,Global_concentration_nonw,Global_brightness_nw,mean(fiterg(1:1,3)),mean(fiterg(1:1,1)), mean(Particle_concentrations(1:1,1)), brightness_eachframe(1) , mean(fiterg5(1:1,3)), mean(fiterg5(1:1,1)), mean(Particle_concentrations_nw(1:1,1)), nanmean(nanmean(nanmean(frame.*Usenan)))/1000/pixeltime, mean(mean(nonfilteredframe(:,:,1)))/1000/pixeltime, nanmean(nanmean(nonfilteredframe(:,:,1).*Usenan))/1000/pixeltime);    

sum(sum(Usenan))

fclose all
close all
clearvars -except kkk listofbatches batchesdir


end


