
%
% This program is free software and not a final version: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as
% published by the Free Software Foundation, either version 2 of the
% License, or (at your option) any later version.
%
% This draft of the script is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details. 


clear 
close all 
simulationhappening=0;

if simulationhappening==0
[filename, pathname]=uigetfile ( 'F:\29122020\*.czi');
else
   [filename, pathname]=uigetfile ( 'F:\29122020\*.mat'); 
end

mapfirst=0;
manualselection=1;
pathbatch=pathname;

shotnoisecorrection=1;   %how many maximum pixels have to be removed
filter=1;
filterwindow=4; % frames for moving average filter
TICS_anal=0;
automaticmapping=0; % 1= making maps of diffusion coefficents
mappingfirstframe=mapfirst; %0 means calculating D from average of all frames; 1 means calculating only from 1st frame
ssize=64; % size in pixels of the mapping subunit
mappingstep=8; %mapping density

startframe=1;


                                                                                                 
%  %%%% for simulations
% % % % % %  
% % % % % %  [filename, pathname]=uigetfile ( 'd:');
% % % % % % mapfirst=0;
% % % % % % 
% % % % % % pathbatch=pathname;
% % % % % %  pixelnumb=size(frame,1);
% % % % % %  pixeltime=100e-6;
% % % % % %  numberframes=size(frame,3);
% % % % % %  pixelsize=0.05;
% % % % % % %   frametime=
% % % % % %  linetime=pixeltime*pixelnumb; 
% % % % % %  SizeX=pixelnumb*pixelsize;
% % % % % %  endframe=numberframes;
% % % % % %  simulationresult=frame;
% % % % % %  %%%
% % % % % %                                                                                                                  
% % % % % %                                                                                                                  
% % % % % %                                                                                                                  
% % % % % %                                                                                                                  
       if simulationhappening==0                                                                                                          
data=bfopen ([pathname  filename]);
% OME Bio-Formats package for reading and converting biological file formats.
%
% Copyright (C) 2007 - 2017 Open Microscopy Environment:
%   - Board of Regents of the University of Wisconsin-Madison
%   - Glencoe Software, Inc.
%   - University of Dundee

imagemetadata=data{1,2};
allKeys = arrayfun(@char, imagemetadata.keySet.toArray, 'UniformOutput', false);
for i=1:size(allKeys,1)
allKeys{i,2}=imagemetadata.get(allKeys{i,1});
end

pixelnumb=str2double(imagemetadata.get('Global Information|Image|SizeX #1'));

pixeltime=str2double(imagemetadata.get('Global Information|Image|Channel|LaserScanInfo|PixelTime #1'));
% linetime= double(frametime/pixelnumb);  % 4.325 ms
% linetime_fromfile_1=str2double(imagemetadata.get('Global Information|Image|Channel|LaserScanInfo|LineTime #1'))
% linetime_fromfile_2=str2double(imagemetadata.get('Global Experiment|AcquisitionBlock|AcquisitionModeSetup|RtLinePeriod #1'))
numberframes=size(data{1, 1},1);
pixelsize=str2double(imagemetadata.get('Global Experiment|AcquisitionBlock|AcquisitionModeSetup|ScalingX #1'))*1000000;
% frametime=str2double(imagemetadata.get('Global Information|Image|Channel|LaserScanInfo|FrameTime #1'))
 frametime=str2double(imagemetadata.get('Global Information|Image|Channel|LaserScanInfo|FrameTime #1'));
 
 
  endframe=numberframes;                                                                                                                 
  
       
       else
           load ([pathname  filename])
           pixelnumb=imagesize;
           numberframes=size(simulationresult,3);
       end
       
 
  SizeX=pixelnumb*pixelsize;
linetime=frametime/pixelnumb;
    
 %  pixelnumb=100; SizeX=pixelnumb*0.04; pixeltime=25e-6; frametime=pixeltime*pixelnumb^2; linetime=pixeltime*pixelnumb;  numberframes=30; pixelsize=0.04; simulationresult=frame;
                                                                                                                 
                                                                                                                 
                                                                                                                 
                                                                                                                 
                                                                                                                 


   
 
if simulationhappening==0
    
        simulationresult=zeros(pixelnumb, pixelnumb,numberframes);

for i=1:numberframes
    simulationresult(:,:,i)=data{1, 1}{i, 1};
end

 
end


                

if endframe-startframe+1>numberframes || isnan(numberframes)
    fprintf(1,'There are not enough frames\n')
    startframe
    endframe
    if isnan(numberframes)
        fprintf(1,'There is only one frame\n')
    else
    numberframes
    end
    error('')
    
    
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%






 




%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%life time filtering

%%%%%end of life time filtering

frame=double(simulationresult(:,:,startframe:endframe));



%%%%start here for simulation


xxx=squeeze(mean(mean(frame)));

if manualselection==1
if automaticmapping==0
figure(66)
plot(xxx)
pause
close 66
end

 figure('units','normalized','outerposition',[0 0 1 1])
    imagesc(sum(frame,3))
    colormap gray
k=1;
while true

   

Use=roipoly;


Usenan=double(Use);
Usenan(Usenan==0)=NaN;

figure(66)
subplot(1,2,1)
try
imagesc(mean(frame,3).*Usenan)
catch 
    close all
    error('Ciao');
end
subplot(1,2,2)
plot(squeeze(nanmean(nanmean(frame.*Usenan))))

button = questdlg( 'Do you want to keep this selection?', ' ','Yes','No','Yes');
switch button
    case 'Yes'
        

    note='';
    
    prompt={'Add note'};
dims=[1 35];
definput={note};
note=inputdlg(prompt,' ', dims, definput);

save([pathbatch '\ARICSbatch_' filename '_' num2str(k) '.mat'], '-regexp', '^(?!(data|frame|imagemetadata)$).');
 filename
 
 
k=k+1;
clear framea Use Usenan
close 66

    case 'No'
     clear framea Use Usenan
close 66   
end


end
end

if manualselection==0
 setappdata(0,'frame',frame)   
 
 h=selectionARICS;
 uiwait(h)
 currentmax=getappdata(0,'currentmax');
 currentmin=getappdata(0,'currentmin');
 
 currentmask=double(sum(frame,3)>=currentmin & sum(frame,3)<=currentmax);
 
 Use=currentmask;
Usenan=double(Use);
Usenan(Usenan==0)=NaN;


figure(66)
subplot(1,2,1)
try
    myimage=mean(frame,3);
    myimage(isnan(myimage))=-1;
imagesc(myimage.*Usenan)
mycolormap = [ ones(1,3); jet(100)];     %tack on a white row to your colormap

colormap(mycolormap);  %call your custom colormap
catch 
    close all
    error('Ciao');
end
subplot(1,2,2)

plot(squeeze(nanmean(nanmean(frame.*Usenan))))

button = questdlg( 'Do you want to keep this selection?', ' ','Yes','No','Yes');
switch button
    case 'Yes'
        

    note='';
    
    prompt={'Add note'};
dims=[1 35];
definput={note};
note=inputdlg(prompt,' ', dims, definput);
k=1;
save([pathbatch '\ARICSbatch_' filename '_' num2str(k) '.mat'], '-regexp', '^(?!(data|frame|imagemetadata)$).');
 filename
 clear framea Use Usenan
close 66
end
end